import alice.tucson.api.*;
import alice.logictuple.*;
import javax.swing.*;

/*Thread che si occupa di osservare i msg che gli notificano se qualche utente
 * entrato in chat
 *
 *@author Rossella Rubino
 *@version agosto1 2004 
 */

public class AgentObserverJoin extends Thread {

	private JTextArea output;
    private TucsonContext context;
    private TupleCentreId myTC;

        public AgentObserverJoin(JTextArea output, AgentId aid, TupleCentreId id) throws Exception {
            this.output=output;
            this.myTC=id;
            context = Tucson.enterContext(new DefaultContextDescription(aid));
        }

        public void run(){
            try {
                while (true) {
                    LogicTuple msg=context.in(myTC,LogicTuple.parse("join(_,_)"));
	                TupleArgument who=msg.getArg(0).getArg(0);
	                
                    output.append("System>  "+who.toString()+" entra in chat\n");
                    output.setCaretPosition(output.getText().length());
                    System.out.println("System>  "+who.toString()+" entra in chat\n");
                }
            } catch (Exception ex){
                ex.printStackTrace();
            }
        }

    }